<?php declare(strict_types = 1);

namespace References\DI;

use Core\DI\CompilerExtension;
use Nette;

class ReferencesExtension extends CompilerExtension
{

	public function loadConfiguration()
	{
		parent::loadConfiguration();
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		$this->compiler->loadDefinitionsFromConfig($this->loadFromFile(__DIR__ . '/services.neon'));
	}

	public function beforeCompile()
	{
		parent::beforeCompile();
		$this->setMapping(['References' => 'References\*Module\Presenters\*Presenter']);
	}
}
