<?php declare(strict_types = 1);

namespace References\FrontModule\Model\Dao;

use Core\Model\Entities\TSeo;
use Nette\Utils\DateTime;

class GeneralReference
{
	use TSeo;

	/** @var int */
	public $id;

	/** @var string */
	public $title;

	/** @var string */
	public $alias;

	/** @var string */
	public $image;

	/** @var string */
	public $introtext;

	/** @var int */
	public $isFeatured;

	/** @var Group */
	public $group;

	/** @var array */
	public $params;

	/** @var DateTime|null */
	public $modified;

	public function setId($id)
	{
		$this->id = $id;

		return $this;
	}

	public function setTitle($title)
	{
		$this->title = $title;

		return $this;
	}

	public function setImage($image)
	{
		$this->image = $image;

		return $this;
	}

	public function setAlias($alias)
	{
		$this->alias = $alias;

		return $this;
	}

	public function setIntrotext($introtext)
	{
		$this->introtext = $introtext;

		return $this;
	}

	public function setIsFeatured($isFeatured)
	{
		$this->isFeatured = $isFeatured;

		return $this;
	}

	public function setGroup(Group $group)
	{
		$this->group = $group;

		return $this;
	}

	public function setParams(array $params)
	{
		$this->params = $params;

		return $this;
	}

	public function setModified($modified)
	{
		$this->modified = $modified;

		return $this;
	}

	public function __get($name)
	{
		if (isset($this->params[$name]))
			return $this->params[$name];

		try {
			return $this->MA__get($name);
		} catch (\Exception $e) {

		}

		return null;
	}

	public function getModified() { return $this->modified; }
}
