<?php declare(strict_types = 1);

namespace References\Model\Entities;

use Doctrine;
use Doctrine\ORM\Event\LifecycleEventArgs;
use Doctrine\ORM\Mapping as ORM;
use Kdyby\Events\Subscriber;
use Nette\Localization\ITranslator;
use Navigations\Model\Navigations;
use Nette\Caching\Cache;
use Nette\Caching\IStorage;
use Nette\SmartObject;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class GeneralListener implements EventSubscriberInterface
{
	use SmartObject;

	/** @var Cache */
	private $navigationCache;

	/** @var ITranslator */
	protected $translator;

	public function __construct(IStorage $cacheStorage, ITranslator $translator)
	{
		$this->navigationCache = new Cache($cacheStorage, Navigations::CACHE_NAMESPACE);
		$this->translator      = $translator;
	}

	public static function getSubscribedEvents()
	{
		return [];
	}

	/**
	 * @ORM\PreFlush
	 *
	 * @param General            $general
	 * @param LifecycleEventArgs $args
	 */
	public function onPreFlush($general, $args)
	{
		$this->navigationCache->clean([Cache::TAGS => Navigations::CACHE_NAMESPACE]);
	}
}
