<?php declare(strict_types=1);

namespace References\Model;

use Core\Model\Helpers\BaseEntityService;
use Core\Model\Helpers\Traits\TPublish;
use References\Model\Entities\General;

/**
 * Class GeneralReferences
 * @package References\Model
 *
 * @method General|object|null getReference($id)
 * @method General[]|null getAll()
 * @method General|null get($id)
 */
class GeneralReferences extends BaseEntityService
{
	use TPublish;

	protected $entityClass = General::class;

	/**
	 * @return string
	 */
	public function getTemplatesDir()
	{
		return TEMPLATES_DIR . '/Front/default/References/TemplateGeneral';
	}

	/**
	 * @param string $name
	 *
	 * @return string
	 */
	public function getTemplateFile($name)
	{
		return $this->getTemplatesDir() . '/' . $name;
	}


	public function setFeatured($id, $state)
	{
		if ($item = $this->get($id)) {
			$item->isFeatured = $state;
			$this->em->persist($item)->flush();

			return true;
		}

	}

	public function setPosition($id, $position)
	{
		if ($item = $this->get($id)) {
			$item->setPosition($position);
			$this->em->persist($item);
			$this->em->flush();

			return true;
		}

		return false;
	}
}