<?php declare(strict_types=1);

namespace SimpleProducts\AdminModule\Components;

use Core\Model\UI\BaseControl;
use SimpleProducts\Model\Categories;
use SimpleProducts\Model\SimpleProducts;

class CategoriesGrid extends BaseControl
{
	/** @var SimpleProducts */
	protected $categoriesService;

	public function __construct(Categories $products)
	{
		$this->categoriesService = $products;
	}

	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentGrid()
	{
		$grid = $this->createGrid();
		$data = $this->categoriesService->getEr()->createQueryBuilder('g');
		$grid->setDataSource($data);

		$grid->addColumnLink('title','default.name2','Default:editCategory');

		return $grid;

	}

}
