<?php declare(strict_types = 1);

namespace SimpleProducts\AdminModule\Components;

use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use SimpleProducts\Model\Categories;
use SimpleProducts\Model\Entities\Category;
use SimpleProducts\Model\SimpleProducts;
use Nette\Http\IResponse;
use Nette\Utils\ArrayHash;

class CategoryForm extends BaseControl
{

	/** @var Category */
	public $category;

	protected $categoriesService;

	public function __construct(Categories $categories)
	{
		$this->categoriesService = $categories;
	}

	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentForm()
	{
		$form = $this->createForm();

		$categories = [null => ''];
		foreach ($this->categoriesService->getEr()->createQueryBuilder('g')->orderBy('g.title')->getQuery()->getResult() as $g) {
			/** @var Category $g */
			if ($this->category && $this->category->getId() == $g->getId())
				continue;

			$arr  = [];
			$t    = $g;
			$skip = false;
			while ($t->getParent()) {
				$t = $t->getParent();
				if ($this->category && $this->category->getId() == $t->getId()) {
					$skip = true;
				}

				$arr[] = $t->title;
			}

			if ($skip)
				continue;

			$categories[$g->getId()] = ($arr ? implode(' -> ', $arr) . ' -> ' : '') . $g->title;
		}

		$form->addText('title', 'default.name2')->setRequired()->setMaxLength(255);
		$form->addBool('isPublished', 'default.isPublished')->setDefaultValue(1);
		$form->addSelect('parent', 'default.parent', $categories);
		$form->addSubmit('submit', 'default.save');

		$form->onSuccess[] = [$this, 'formSuccess'];

		return $form;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values)
	{
		try {
			if ($this->category) {
				$category     = $this->category;
				$flashMessage = 'simpleProducts.categoryForm.edited';
			} else {
				$category     = new Category($values->title);
				$flashMessage = 'simpleProducts.categoryForm.added';
			}

			$category->title       = $values->title;
			$category->isPublished = $values->isPublished;

			if ($values->parent == '') {
				$category->setParent(null);
			} else {
				$category->setParent($this->categoriesService->get($values->parent));
			}

			$this->em->persist($category)->flush();
			$this->getPresenter()->flashMessageSuccess($flashMessage);
		} catch (\Exception $e) {
			$form->addError($e->getMessage());

			return false;
		}
	}

	public function setCategory($id)
	{

		$this->category = $this->categoriesService->get($id);

		if ($this->category) {
			$this['form']->setDefaults([
				'title'       => $this->category->title,
				'isPublished' => $this->category->isPublished
			]);

			if ($this->category->parent && array_key_exists($this->category->parent->getId(), $this['form']['parent']->getItems())) {
				$this['form']['parent']->setDefaultValue($this->category->parent->getId());
			}
		} else
			$this->getPresenter()->error(null, IResponse::S404_NOT_FOUND);
	}

}
