<?php declare(strict_types=1);

namespace SimpleProducts\AdminModule\Components;

use Core\Model\UI\BaseControl;
use SimpleProducts\Model\SimpleProducts;

class ProductsGrid extends BaseControl
{
	/** @var SimpleProducts */
	protected $productsService;

	public function __construct(SimpleProducts $products)
	{
		$this->productsService = $products;
	}

	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentGrid()
	{
		$grid = $this->createGrid();
		$data = $this->productsService->getEr()->findBy([], ['title' => 'ASC']);
		$grid->setDataSource($data);
		$grid->setDefaultPerPage(10);

		$grid->addColumnLink('title','default.signification','Default:editProduct');
		$grid->addColumnStatus('isPublished', 'default.isPublished')->setAlign('center')
			->addOption(1, 'default.publish')
				->setIcon('check')
				->setClass('btn-success')
				->setShowTitle(false)->endOption()
			->addOption(0, 'default.unPublish')
				->setIcon('times')
				->setClass('btn-danger')
				->setShowTitle(false)
				->endOption()
			->onChange[] = [$this, 'gridPublishChange'];

		$grid->addAction('edit', '', 'Default:editGroup')
			->setIcon('edit')
			->setBsType('primary');
		$grid->addAction('delete', '', 'delete!')
			->setConfirm('default.reallyDelete')
			->setIcon('times')
			->setBsType('danger')
			->addClass('ajax');

		return $grid;

	}

	public function handleDelete($id)
	{
		$presenter = $this->getPresenter();
		if ($this->productsService->remove($id))
			$presenter->flashMessageSuccess('default.removed');
		else
			$presenter->flashMessageDanger('default.removeFailed');

		if ($presenter->isAjax()) {
			$this['grid']->reload();
			$presenter->redrawControl('flashes');
		} else
			$presenter->redirect('this');
	}

	public function gridPublishChange($id, $newStatus)
	{
		$presenter = $this->getPresenter();

		if ($this->productsService->setPublish($id, $newStatus))
			$presenter->flashMessageSuccess('default.publishChanged');
		else
			$presenter->flashMessageDanger('default.publishChangeFailed');

		if ($presenter->isAjax()) {
			$this['grid']->redrawItem($id);
			$presenter->redrawControl('flashes');
		} else
			$presenter->redirect('this');
	}

}

