<?php declare(strict_types=1);

namespace SimpleProducts\AdminModule\Presenters;

use Nette\Http\IResponse;
use SimpleProducts\AdminModule\Components\ICategoriesGridFactory;
use SimpleProducts\AdminModule\Components\ICategoryFormFactory;
use SimpleProducts\AdminModule\Components\IProductFormFactory;
use SimpleProducts\AdminModule\Components\IProductsGridFactory;
use SimpleProducts\Model\Entities\Category;
use SimpleProducts\Model\Entities\Product;

final class DefaultPresenter extends BasePresenter
{
	protected function startup()
	{
		parent::startup();
		$this['title']->setTitle($this->translator->translate('simpleProducts.title.products'));
		$this->setHeader('simpleProducts.title.products', 'fa fa-box-open');
	}

	public function actionDefault()
	{
		$this['navigation']->setData(['header' => [
			[
				'title' => 'simpleProducts.menu.addCategory',
				'link' => 'Default:addCategory',
				'ico' => 'plus',
			], [
				'title' => 'simpleProducts.menu.addProduct',
				'link' => 'Default:addProduct',
				'ico' => 'plus',
			],
		]]);
	}

	public function actionAddCategory()
	{
		$this->setTitle($this->translator->translate('simpleProducts.title.addCategory'));
		$this->setHeader('simpleProducts.title.addCategory', 'fa fa-box-open');
	}

	public function actionAddProduct()
	{
		$this->setTitle($this->translator->translate('simpleProducts.title.addProduct'));
		$this->setHeader('simpleProducts.title.addProduct', 'fa fa-box-open');
	}

	public function actionEditCategory($id)
	{

		$category = $this->em->getRepository(Category::class)->find($id);

		if (!$category)
			$this->error(null, IResponse::S404_NOT_FOUND);

		$this->setTitle($this->translator->translate('simpleProducts.title.editCategory'));
		$this->setHeader('simpleProducts.title.editCategory', 'fa fa-box-open');
	}

	public function actionEditProduct($id)
	{

		$product = $this->em->getRepository(Product::class)->find($id);

		if (!$product)
			$this->error(null, IResponse::S404_NOT_FOUND);

		$this->setTitle($this->translator->translate('simpleProducts.title.editProduct'));
		$this->setHeader('simpleProducts.title.editProduct', 'fa fa-box-open');
	}

	public function createComponentProductsGrid(IProductsGridFactory $factory)
	{
		return $factory->create();
	}

	public function createComponentCategoriesGrid(ICategoriesGridFactory $factory)
	{
		return $factory->create();
	}

	public function createComponentCategoryForm(ICategoryFormFactory $factory)
	{
		$control = $factory->create();

		if ($this->getParameter('id'))
			$control->setCategory($this->getParameter('id'));

		$control['form']->onSuccess['redirect'] = function() {
			$this->redirect('default');
		};

		return $control;
	}

	public function createComponentProductForm(IProductFormFactory $factory)
	{
		$control = $factory->create();

		if ($this->getParameter('id'))
			$control->setProduct($this->getParameter('id'));

		$control['form']->onSuccess['redirect'] = function() {
			$this->redirect('default');
		};

		return $control;
	}

}