<?php

namespace SimpleProducts\FrontModule\Model;

use Core\Model\Helpers\BaseEntityService;
use SimpleProducts\Model\Entities\Product;
use SimpleProducts\FrontModule\Model\Dao as ProductsDao;

class SimpleProducts extends BaseEntityService
{
	protected $entityClass = Product::class;

	public function getAll()
	{
		$productsRaw = $this->getEr()->createQueryBuilder('p')
			->orderBy('p.title', 'ASC')
			->getQuery()
			->getResult();

		$products = [];
		foreach ($productsRaw as $product) {
			$products[$product->getId()] = $product;
		}


		return $products;
	}
}