<?php declare(strict_types = 1);

namespace SimpleProducts\FrontModule\Presenters;

use SimpleProducts\FrontModule\Model\SimpleProducts;

final class DefaultPresenter extends BasePresenter
{
	/** @var SimpleProducts */
	protected $productsService;

	public function __construct(SimpleProducts $products)
	{
		$this->productsService = $products;
	}

	public function actionDefault()
	{
		bdump($this->productsService->getAll());
	}

	public function handleGetProducts()
	{
		bdump("inmethod");
		$data = $this->productsService->getAll();
		$this->payload->data = $data;
		$this->sendPayload();
	}
}