<?php declare(strict_types = 1);

namespace SimpleProducts\AdminModule\Components;

use Core\Model\UI\BaseControl;
use SimpleProducts\Model\SimpleProducts;

class ProductsSortGrid extends BaseControl
{
	/** @var SimpleProducts */
	protected $productsService;

	public function __construct(SimpleProducts $products)
	{
		$this->productsService = $products;
	}

	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}

	public function handleFixSorting()
	{
		if ($this->productsService->fixSorting())
			$this->getPresenter()->flashMessageSuccess('default.saved');
		else
			$this->getPresenter()->flashMessageDanger('default.error');
		$this->getPresenter()->redrawControl('flashes');
	}

	protected function createComponentGrid()
	{
		$grid = $this->createGrid();
		$data = $this->productsService->getEr()->findBy([], ['position' => 'ASC']);
		$grid->setDataSource($data);
		$grid->setItemsPerPageList([], true);
		$grid->setDefaultPerPage('all');

		$grid->setSortable();
		$grid->setSortableHandler('productsSortGrid:gridSortableRow!');
		$grid->setSortableGroup('group');

		$grid->addColumnLink('title', 'default.signification', 'Default:editProduct');

		return $grid;
	}

	public function handleGridSortableRow()
	{
		$presenter = $this->getPresenter();
		$request   = $presenter->getHttpRequest();
		$id        = $request->getPost('id', null);
		$position  = $request->getPost('position', null);
		bdump($position);

		if ($id != null && $position != null && $this->productsService->setPosition($id, $position)) {
			$presenter->flashMessageSuccess('default.positionChanged');
		} else {
			$presenter->flashMessageDanger('default.positionChangeFailed');
		}

		$presenter->redrawControl('flashes');
	}
}

