<?php declare(strict_types = 1);

namespace SimpleProducts\FrontModule\Model\Dao;

class Category
{
    /** @var string */
	public $title;

	/** @var Product[] */
	public $products;

	/** @var string */
	public $alias;

	/** @var string */
	public $layout;

	/** @var int */
	public $isPublished;

	/** @var Category[] */
	public $children;

	/** @var Category */
	public $parent;


	/**
	 * @param string $title
	 * @return Category
	 */
	public function setTitle(string $title): Category
	{
		$this->title = $title;
		return $this;
	}

	/**
	 * @param Product[] $products
	 * @return Category
	 */
	public function setProducts(array $products): Category
	{
		$this->products = $products;
		return $this;
	}

	/**
	 * @param string $alias
	 * @return Category
	 */
	public function setAlias(string $alias): Category
	{
		$this->alias = $alias;
		return $this;
	}

	/**
	 * @param string $layout
	 * @return Category
	 */
	public function setLayout(string $layout): Category
	{
		$this->layout = $layout;
		return $this;
	}

	/**
	 * @param int $isPublished
	 * @return Category
	 */
	public function setIsPublished(int $isPublished): Category
	{
		$this->isPublished = $isPublished;
		return $this;
	}

	/**
	 * @param Category[] $children
	 * @return Category
	 */
	public function setChildren(array $children): Category
	{
		$this->children = $children;
		return $this;
	}

	/**
	 * @param Category $parent
	 * @return Category
	 */
	public function setParent(Category $parent): Category
	{
		$this->parent = $parent;
		return $this;
	}






}