<?php declare(strict_types = 1);

namespace SimpleProducts\FrontModule\Model\Dao;

use Kdyby\Doctrine\Entities\MagicAccessors;

class Product
{
	use MagicAccessors {
		__get as MA__get;
	}
	/** @var string */
	public $title;

    /** @var float */
	public $price;

	/** @var string */
	public $description;

	/** @var string  */
	public $externalUrl;

	/** @var string */
	public $availability;

	/** @var string */
	public $image;

	/** @var int */
	public $inStock;

	/** @var int */
	public $isPublished;

	/** @var array */
	public $params;

	/** @var Product */
	public $alternativeOf;

	/** @var Product[] */
	public $alternatives;

	/** @var Category[] */
	public $categories;


	/**
	 * @param string $title
	 * @return Product
	 */
	public function setTitle(string $title): Product
	{
		$this->title = $title;
		return $this;
	}

	/**
	 * @param float $price
	 * @return Product
	 */
	public function setPrice(float $price): Product
	{
		$this->price = $price;
		return $this;
	}

	/**
	 * @param string $description
	 * @return Product
	 */
	public function setDescription(string $description): Product
	{
		$this->description = $description;
		return $this;
	}

	/**
	 * @param string $externalUrl
	 * @return Product
	 */
	public function setExternalUrl(string $externalUrl): Product
	{
		$this->externalUrl = $externalUrl;
		return $this;
	}

	/**
	 * @param string $availability
	 * @return Product
	 */
	public function setAvailability(string $availability): Product
	{
		$this->availability = $availability;
		return $this;
	}

	/**
	 * @param string $image
	 * @return Product
	 */
	public function setImage(string $image): Product
	{
		$this->image = $image;
		return $this;
	}

	/**
	 * @param int $inStock
	 * @return Product
	 */
	public function setInStock(int $inStock): Product
	{
		$this->inStock = $inStock;
		return $this;
	}

	/**
	 * @param int $isPublished
	 * @return Product
	 */
	public function setIsPublished(int $isPublished): Product
	{
		$this->isPublished = $isPublished;
		return $this;
	}

	/**
	 * @param array $params
	 * @return Product
	 */
	public function setParams(array $params): Product
	{
		$this->params = $params;
		return $this;
	}

	/**
	 * @param Product $alternativeOf
	 * @return Product
	 */
	public function setAlternativeOf(Product $alternativeOf): Product
	{
		$this->alternativeOf = $alternativeOf;
		return $this;
	}

	/**
	 * @param Product[] $alternatives
	 * @return Product
	 */
	public function setAlternatives(array $alternatives): Product
	{
		$this->alternatives = $alternatives;
		return $this;
	}

	/**
	 * @param Category[] $categories
	 * @return Product
	 */
	public function setCategories(array $categories): Product
	{
		$this->categories = $categories;
		return $this;
	}

	public function &__get($name)
	{
		return $this->params[$name] ?? $this->MA__get($name);
	}


}