<?php declare(strict_types = 1);

namespace SimpleProducts\FrontModule\Presenters;

use SimpleProducts\FrontModule\Model\SimpleProducts;
use SimpleProducts\Model\Entities\Product;

final class DefaultPresenter extends BasePresenter
{
	/** @var SimpleProducts */
	protected $productsService;

	public function __construct(SimpleProducts $products)
	{
		$this->productsService = $products;
	}

	public function actionDefault()
	{
		bdump($this->productsService->getAll());
	}

	public function handleGetProducts()
	{
		bdump("inmethod");
		$data = [];
		foreach ($this->productsService->getAll() as $product) {
			/** @var Product $product */
			$data[$product->getId()] = [
				'id'            => $product->getId(),
				'title'         => $product->title,
				'price'         => $product->price,
				'description'   => $product->description,
				'externalUrl'   => $product->externalUrl,
				'externalUrl2'  => $product->getExternalUrl2(),
				'availability'  => $product->availability,
				'image'         => $product->image,
				'inStock'       => $product->inStock,
				'isPublished'   => $product->isPublished,
				'params'        => $product->getParams(),
				'alternativeOf' => $product->alternativeOf ? $product->alternativeOf->getId() : null,
				'categories'    => $product->categories->getKeys(),
				'productId'     => $product->productId,
				'position'      => $product->getPosition(),
			];
		}

		$this->payload->data = $data;
		$this->sendPayload();
	}
}
