<?php
/**
 * Created by PhpStorm.
 * User: Adam Ouhrabka
 * Date: 11.10.2018
 * Time: 12:53
 */

namespace SimpleProducts\Model\Navigation;

use Core\Components\Navigation\DaoNavigationItem;
use Core\Model\UI\Form\BaseContainer;
use Core\Model\UI\Form\BaseForm;
use Navigations\Model\Entities\Navigation;
use Navigations\Model\Providers\INavigationItem;
use Nette\Utils\ArrayHash;

class SimpleProducts extends BaseNavigation implements INavigationItem
{

	protected $title     = 'products';
	protected $presenter = 'SimpleProducts:Front:Default';
	protected $action    = 'default';

	/**
	 * @return BaseContainer
	 */
	public function getFormContainer()
	{
		$container = new BaseContainer();

		return $container;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values)
	{
	}

	/**
	 * @param $presenter
	 * @param $action
	 *
	 * @return bool
	 */
	public function presenterActionCheck($presenter, $action)
	{
		if ($this->presenter == $presenter && $this->action == $action)
			return 1;

		return false;
	}

	/**
	 * @param       $componentParams
	 * @param array $urlParams
	 *
	 * @return mixed
	 */
	public function routerIn($componentParams, $urlParams = [])
	{
		return [
			'presenter' => $this->presenter,
			'action'    => $this->action,
			'id'        => null,
		];
	}

	public function routerOut(DaoNavigationItem $navigation, &$urlParams): ?string
	{
		return $navigation->isHomepage ? '' : '/' . $navigation->alias;
	}
}
