<?php declare(strict_types = 1);

namespace SimpleProducts\Model;

use Core\Model\Helpers\BaseEntityService;
use Core\Model\Helpers\Traits\TPublish;
use SimpleProducts\Model\Entities\Product;

class SimpleProducts extends BaseEntityService
{
	use TPublish;

	protected $entityClass = Product::class;

	public function setPosition($id, $position)
	{
		if ($item = $this->get($id)) {
			$item->setPosition($position);
			$this->em->persist($item);
			$this->em->flush();

			return true;
		}

		return false;
	}

	public function fixSorting()
	{
		try {
			foreach ($this->getEr()->createQueryBuilder('p')
				         ->select('p.id')
				         ->orderBy('p.position', ASC)
				         ->addOrderBy('p.title', 'ASC')
				         ->getQuery()->getArrayResult() as $k => $row) {
				$this->em->getConnection()->executeQuery("UPDATE simple_products__product SET position = ? WHERE id = ?",
					[$k, $row['id']]);
			}

			return true;
		} catch (\Exception $e) {
			bdump($e->getMessage());
		}

		return false;
	}
}
