<?php declare(strict_types=1);

namespace Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20180914073312 extends AbstractMigration
{
    public function up(Schema $schema) : void
    {
        // this up() migration is auto-generated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

        $this->addSql('CREATE TABLE products__category (id INT AUTO_INCREMENT NOT NULL, parent_id INT DEFAULT NULL, title VARCHAR(255) NOT NULL, alias VARCHAR(255) NOT NULL, layout VARCHAR(60) NOT NULL, is_published SMALLINT NOT NULL, created DATETIME NOT NULL, INDEX IDX_7AF1BF87727ACA70 (parent_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE products__product (id INT AUTO_INCREMENT NOT NULL, title VARCHAR(255) NOT NULL, price DOUBLE PRECISION NOT NULL, description LONGTEXT NOT NULL, url VARCHAR(255) NOT NULL, availability VARCHAR(255) NOT NULL, in_stock VARCHAR(255) NOT NULL, is_published SMALLINT NOT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE products__category_product (product_id INT NOT NULL, category_id INT NOT NULL, INDEX IDX_456D64884584665A (product_id), INDEX IDX_456D648812469DE2 (category_id), PRIMARY KEY(product_id, category_id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
        $this->addSql('ALTER TABLE products__category ADD CONSTRAINT FK_7AF1BF87727ACA70 FOREIGN KEY (parent_id) REFERENCES products__category (id) ON DELETE SET NULL');
        $this->addSql('ALTER TABLE products__category_product ADD CONSTRAINT FK_456D64884584665A FOREIGN KEY (product_id) REFERENCES products__product (id)');
        $this->addSql('ALTER TABLE products__category_product ADD CONSTRAINT FK_456D648812469DE2 FOREIGN KEY (category_id) REFERENCES products__category (id)');
    }

    public function down(Schema $schema) : void
    {
        // this down() migration is auto-generated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

        $this->addSql('ALTER TABLE products__category DROP FOREIGN KEY FK_7AF1BF87727ACA70');
        $this->addSql('ALTER TABLE products__category_product DROP FOREIGN KEY FK_456D648812469DE2');
        $this->addSql('ALTER TABLE products__category_product DROP FOREIGN KEY FK_456D64884584665A');
        $this->addSql('DROP TABLE products__category');
        $this->addSql('DROP TABLE products__product');
        $this->addSql('DROP TABLE products__category_product');
    }
}
