<?php declare(strict_types = 1);

namespace Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20200501101551 extends AbstractMigration
{
	public function up(Schema $schema): void
	{
		// this up() migration is auto-generated, please modify it to your needs
		$this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

		$this->addSql('ALTER TABLE simple_products__product ADD product_id VARCHAR(255) DEFAULT NULL');
	}

	public function postUp(Schema $schema)
	{
		parent::postUp($schema);

		foreach ($this->connection->fetchAll("SELECT id, url2 FROM simple_products__product") as $row) {
			if (!$row['url2'])
				continue;

			preg_match('/articles\=(.*)\&c=checkout/', $row['url2'], $matches);
			if (!isset($matches[1]))
				continue;

			$this->connection->update('simple_products__product', [
				'product_id' => trim($matches[1]),
			], [
				'id' => $row['id'],
			]);
		}
	}

	public function down(Schema $schema): void
	{
		// this down() migration is auto-generated, please modify it to your needs
		$this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

		$this->addSql('ALTER TABLE simple_products__product DROP product_id');
	}
}
