<?php declare(strict_types = 1);

namespace Slides\AdminModule\Components;

use Blog\Model\UI;
use Core\Model\UI\BaseControl;
use Nette\Forms\Form;
use Nette\Http\IResponse;
use Nette\Utils\ArrayHash;
use Slides\Model\Entities\Slide;
use Slides\Model\SlideGroups;

class SlideForm extends BaseControl
{
	/** @var Slide */
	public $slide;

	/** @var SlideGroups */
	private $slideGroupsService;

	public function __construct(SlideGroups $slideGroups)
	{
		$this->slideGroupsService = $slideGroups;
	}

	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentForm()
	{
		$form = $this->createForm();

		$groups = [];
		foreach ($this->slideGroupsService->getAll() as $g)
			$groups[$g->getId()] = $g->title;

		$form->addText('title', 'default.title')->setMaxLength(255)->setRequired();
		$form->addBool('isPublished', 'default.isPublished')->setDefaultValue(1);
		$form->addText('link', 'default.link');
		$form->addTextArea('text', 'default.text');
		$form->addFilesManager('image', 'default.image');
		$form->addSelect('group', 'default.group', $groups)->setRequired();
		$form->addSubmit('submit', 'default.save');

		$form->onSuccess[] = [$this, 'formSuccess'];

		return $form;
	}

	public function formSuccess(Form $form, ArrayHash $values)
	{
		try {
			$group = $this->slideGroupsService->getReference($values->group);

			if ($this->slide) {
				$slide        = $this->slide;
				$flashMessage = 'slides.slideForm.edited';
			} else {
				$slide        = new Slide($values->title, $group, $values->isPublished);
				$flashMessage = 'slides.slideForm.added';
			}

			$slide->title       = $values->title;
			$slide->isPublished = $values->isPublished;
			$slide->link        = $values->link;
			$slide->text        = $values->text;
			$slide->image       = $values->image;
			$slide->group       = $group;

			$this->em->persist($slide)->flush();
			$this->getPresenter()->flashMessageSuccess($flashMessage);
		} catch (\Exception $e) {
			$form->addError($e->getMessage());

			return false;
		}
	}

	public function setSlide($id)
	{
		$this->slide = $this->em->getRepository(Slide::class)->find($id);

		if ($this->slide) {
			$s = $this->slide;
			$f = $this['form'];

			$f->setDefaults([
				'title'       => $s->title,
				'isPublished' => $s->isPublished,
				'link'        => $s->link,
				'text'        => $s->text,
				'image'       => $s->image,
			]);

			if ($s->group && array_key_exists($s->group->getId(), $f['group']->getItems()))
				$f['group']->setDefaultValue($s->group->getId());
		} else
			$this->getPresenter()->error(null, IResponse::S404_NOT_FOUND);
	}
}
