<?php declare(strict_types = 1);

namespace Slides\AdminModule\Presenters;

use Nette\Http\IResponse;
use Nette\Utils\Html;
use Slides\AdminModule\Components\ISlideFormFactory;
use Slides\AdminModule\Components\ISlideGroupFormFactory;
use Slides\AdminModule\Components\ISlideGroupsGridFactory;
use Slides\AdminModule\Components\ISlidesGridFactory;
use Slides\Model\Entities\Slide;
use Slides\Model\Entities\SlideGroup;

final class DefaultPresenter extends BasePresenter
{

	protected function startup()
	{
		parent::startup();
		$this['title']->setTitle($this->translator->translate('slides.title.slideshow'));
	}

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionDefault()
	{
		$this['navigation']->setData(['header' => [
			[
				'title' => 'slides.menu.newSlide',
				'link'  => 'Default:add',
				'ico'   => 'plus',
			], [
				//TODO popup
				'title' => 'slides.menu.newSlideGroup',
				'link'  => 'Default:addGroup',
				'ico'   => 'plus',
			]
		]]);

		$this['slideGroupsGrid']->onGroupDelete[] = function() {
			$this['slidesGrid']['grid']->reload();
		};
	}

	public function actionAdd()
	{
		$this->setTitle($this->translator->translate('slides.title.newSlide'));
	}

	public function actionAddGroup()
	{
		$this->setTitle($this->translator->translate('slides.title.newSlideGroup'));
	}

	public function actionEdit($id)
	{
		$slide = $this->em->getRepository(Slide::class)->find($id);

		if (!$slide)
			$this->error(null, IResponse::S404_NOT_FOUND);

		$this->setTitle($this->translator->translate('slides.title.editSlide'), $slide->title);
	}

	public function actionEditGroup($id)
	{
		$group = $this->em->getRepository(SlideGroup::class)->find($id);

		if (!$group)
			$this->error(null, IResponse::S404_NOT_FOUND);

		$this->setTitle($this->translator->translate('slides.title.editSlideGroup'), $group->title);
	}

	/*******************************************************************************************************************
	 * ============================== Components
	 */

	protected function createComponentSlidesGrid(ISlidesGridFactory $factory)
	{
		return $factory->create();
	}

	protected function createComponentSlideForm(ISlideFormFactory $factory)
	{
		$control = $factory->create();

		if ($this->getParameter('id'))
			$control->setSlide($this->getParameter('id'));

		$control['form']->onSuccess['redirect'] = function() {
			$this->redirect('default');
		};

		return $control;
	}

	protected function createComponentSlideGroupsGrid(ISlideGroupsGridFactory $factory)
	{
		return $factory->create();
	}

	protected function createComponentSlideGroupForm(ISlideGroupFormFactory $factory)
	{
		$control = $factory->create();

		if ($this->getParameter('id'))
			$control->setSlideGroup($this->getParameter('id'));

		$control['form']->onSuccess['redirect'] = function() {
			$this->redirect('default');
		};

		return $control;
	}
}