<?php declare(strict_types = 1);

namespace Slides\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;

/**
 * @ORM\Table(name="slides__slide")
 * @ORM\Entity
 */
class Slide
{
	use Identifier;
	use MagicAccessors;

	/**
	 * @var string
	 * @ORM\Column(name="title", type="string", length=255, nullable=false)
	 */
	public $title;

	/**
	 * @var int
	 * @ORM\Column(name="is_published", type="smallint")
	 */
	public $isPublished;

	/**
	 * @var string
	 * @ORM\Column(name="link", type="string", length=255, nullable=true)
	 */
	public $link;

	/**
	 * @var string
	 * @ORM\Column(name="`text`", type="text", nullable=true)
	 */
	public $text;

	/**
	 * @var string
	 * @ORM\Column(name="image", type="string", nullable=true)
	 */
	public $image;

	/**
	 * @var int
	 *
	 * @Gedmo\SortablePosition
	 * @ORM\Column(name="position", type="integer")
	 */
	private $position;

	/**
	 * @var SlideGroup
	 * @Gedmo\SortableGroup
	 * @ORM\ManyToOne(targetEntity="SlideGroup", inversedBy="slides")
	 * @ORM\JoinColumn(name="group_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public $group;

	public function __construct($title, $group, $isPublished = 0)
	{
		$this->title = $title;
		$this->group = $group;
		$this->isPublished = $isPublished;
		$this->setPosition(-1);
	}

	/******
	 * === Position
	 */

	public function setPosition($position)
	{
		$this->position = $position;
	}

	public function getPosition()
	{
		return $this->position;
	}

//	/*****
//	 * === Image
//	 */
//
//	public function getImage() { return $this->image; }
}