<?php declare(strict_types = 1);

namespace Slides\Model\Navigation;

use Core\Model\UI\Form\BaseContainer;
use Core\Model\UI\Form\BaseForm;
use Navigations\Model\Entities\Navigation;
use Navigations\Model\Providers\INavigationItem;
use Nette\Utils\ArrayHash;
use Slides\Model\SlideGroups;
use Slides\Model\Slides;

class Grid extends BaseNavigation implements INavigationItem
{
	protected $title     = 'grid';
	protected $presenter = 'Slides:Front:Default';
	protected $action    = 'grid';

	/** @var Slides */
	protected $slidesService;

	/** @var SlideGroups */
	protected $slideGroupsService;

	public function __construct(Slides $slides, SlideGroups $slideGroups)
	{
		$this->slidesService      = $slides;
		$this->slideGroupsService = $slideGroups;
	}

	/**
	 * @return BaseContainer
	 */
	public function getFormContainer()
	{
		$container = new BaseContainer();

		$groups = [];
		foreach ($this->slideGroupsService->getAll() as $group)
			$groups[$group->getId()] = $group->title;

		$container->addSelect('group', 'slides.navigationForm.group', $groups);

		return $container;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values)
	{
	}

	/*******************************************************************************************************************
	 * ===========================  Route
	 */

	public function presenterActionCheck($presenter, $action)
	{
		if ($this->presenter == $presenter && $this->action == $action)
			return 1;

		return false;
	}

	public function routerIn($params, $urlParams = [])
	{
		return [
			'presenter' => $this->presenter,
			'action'    => $this->action,
			'id'        => $params['group'],
		];
	}

	public function routerOut($navigation, &$urlParams)
	{
		if ($navigation instanceof Navigation == false)
			return false;

		if (isset($navigation->componentParams['group']) && isset($urlParams['id']) && $navigation->componentParams['group'] == $urlParams['id']) {
			return $navigation->alias;
		}

		return false;
	}
}