<?php declare(strict_types = 1);

namespace Slides\AdminModule\Model;

use Core\Model\Helpers\BaseEntityService;
use Core\Model\Helpers\Traits\TPublish;
use Slides\Model\Entities\Slide;

/**
 * Class Slides
 * @package Slides\AdminModule\Model
 *
 * @method Slide|object|null getReference($id)
 * @method Slide[]|null getAll()
 * @method Slide|null get($id)
 */
class Slides extends BaseEntityService
{
	use TPublish;

	protected $entityClass = Slide::class;

	/**
	 * @return string
	 */
	public function getTemplatesDir()
	{
		return TEMPLATES_DIR . '/Front/default/Slides/TemplateSlide';
	}
}
