<?php declare(strict_types = 1);

namespace Slides\Model\Entities;

use Doctrine;
use Doctrine\ORM\Event\LifecycleEventArgs;
use Doctrine\ORM\Mapping as ORM;
use Kdyby\Events\Subscriber;
use Kdyby\Translation\Translator;
use Navigations\Model\Navigations;
use Nette\Caching\Cache;
use Nette\Caching\IStorage;
use Nette\SmartObject;
use Slides\FrontModule\Model\Slides;
use Slides\Model\Entities\Slide;

class SlideListener implements Subscriber
{
	use SmartObject;

	/** @var Cache */
	protected $cache;

	/** @var Cache */
	private $navigationCache;

	/** @var Translator */
	protected $translator;

	public function __construct(IStorage $cacheStorage, Translator $translator)
	{
		$this->cache           = new Cache($cacheStorage, Slides::CACHE_NAMESPACE);
		$this->navigationCache = new Cache($cacheStorage, Navigations::CACHE_NAMESPACE);
		$this->translator      = $translator;
	}

	public function getSubscribedEvents()
	{
		return [];
	}

	/**
	 * @ORM\PreFlush
	 *
	 * @param Slide              $slide
	 * @param LifecycleEventArgs $args
	 */
	public function onPreFlush($slide, $args)
	{
		$this->cache->clean([
			Cache::TAGS => [
				'slidesByGroup/' . $slide->group->getId(),
				'group/' . $slide->group->getId(),
			],
		]);
	}
}
