<?php declare(strict_types = 1);

namespace Slides\AdminModule\Components;

use Core\Model\UI\BaseControl;
use Slides\Model\SlideGroups;

class SlideGroupsGrid extends BaseControl
{
	/** @var SlideGroups */
	protected $slideGroupsService;

	/** @var callable */
	public $onGroupDelete = [];

	public function __construct(SlideGroups $slideGroups)
	{
		$this->slideGroupsService = $slideGroups;
	}

	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentGrid()
	{
		$grid = $this->createGrid();

		$qb = $this->slideGroupsService->getEr()->createQueryBuilder('t');
		$grid->setDataSource($qb);

		// Columns
		$grid->addColumnLink('title', 'default.title', 'Default:editGroup');

		// Filter
		$grid->addFilterText('title', '');

		// Actions
		$grid->addAction('edit', '', 'Default:editGroup')->setIcon('edit')->setBsType('primary');
		$grid->addAction('delete', '', 'delete!')->setIcon('times')->setBsType('danger')->setConfirm('slides.slideGroupsGrid.confirmRemove')->addClass('ajax');


		return $grid;
	}

	/*******************************************************************************************************************
	 * ==================  Handle
	 */

	public function handleDelete($id)
	{
		$presenter = $this->getPresenter();
		if ($this->slideGroupsService->remove($id))
			$presenter->flashMessageSuccess('default.removed');
		else
			$presenter->flashMessageDanger('default.removeFailed');

		if ($presenter->isAjax()) {
			$this['grid']->reload();
			$this->onGroupDelete($id);
			$presenter->redrawControl('flashes');
		} else
			$presenter->redirect('this');
	}
}
