<?php declare(strict_types = 1);

namespace Slides\FrontModule\Presenters;

use Slides\Model\Slides;

final class DefaultPresenter extends BasePresenter
{
	/** @var Slides */
	protected $slidesService;

	public function __construct(Slides $slides)
	{
		$this->slidesService = $slides;
	}

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionGrid($id)
	{
		if (!$id)
			$this->error();

		$this->template->items = $this->slidesService->getPublishedByGroup($id);

		if ($this->isAjax()) {
			$this->template->_imagePipe = $this->imagePipe;
			$this->setLayout(APP_DIR . '/modules/@emptyLayout.latte');
			ob_start();
			echo "<div>";
			$this->template->setFile(__DIR__ . '/templates/Default/grid.latte');
			$this->getTemplate()->render();
			echo "</div>";
			$this->payload->html = ob_get_clean();
			$this->sendPayload();
		}
	}

	/*******************************************************************************************************************
	 * ============================== Components
	 */
}