<?php declare(strict_types = 1);

namespace Slides\Model;

use Core\Model\Helpers\BaseEntityService;
use Slides\Model\Entities\Slide;

/**
 * Class Slides
 * @package Slides\Model
 *
 * @method Slide|object|null getReference($id)
 * @method Slide[]|null getAll()
 * @method Slide|null get($id)
 */
class Slides extends BaseEntityService
{
	protected $entityClass = Slide::class;

	// TODO traita
	public function setPublish($id, $state)
	{
		if ($item = $this->get($id)) {
			$item->isPublished = $state;
			$this->em->persist($item);
			$this->em->flush();

			return true;
		}

		return false;
	}

	/**
	 * @param $groupId
	 *
	 * @return Slide[]|null
	 */
	public function getPublishedByGroup($groupId)
	{
		return $this->getEr()->findBy(['isPublished' => 1, 'group' => $groupId], ['position' => 'ASC']);
	}

	/**
	 * TODO traita
	 *
	 * @param $id
	 * @param $position
	 *
	 * @return bool
	 * @throws \Exception
	 */
	public function setPosition($id, $position)
	{
		if ($item = $this->getReference($id)) {
			$item->setPosition($position);
			$this->em->persist($item);
			$this->em->flush();

			return true;
		}

		return false;
	}
}