<?php declare(strict_types = 1);

namespace Slides\FrontModule\Model\Dao;

use Kdyby\Doctrine\Entities\MagicAccessors;

/**
 * Class Group
 * @package Slides\FrontModule\Model\Dao
 */
class Group
{
	use MagicAccessors;

	/** @var int */
	protected $id;

	/** @var string */
	protected $title;

	/** @var Slide */
	protected $slides;

	/**
	 * @param Slide[] $slides
	 *
	 * @return $this
	 */
	public function setSlides($slides)
	{
		$this->slides = [];

		foreach ($slides as $v) {
			$this->slides[$v->getId()] = $v;
			$v->setGroup($this);
		}

		return $this;
	}
}
