<?php declare(strict_types = 1);

namespace Slides\Model\TemplateTextType;

use Contributte\Latte\Exception\Logical\InvalidArgumentException;
use Core\Model\TemplateReader\Providers\ITemplateTextType;
use Core\Model\TemplateReader\Providers\TemplateTextType;
use Core\Model\UI\Form\BaseContainer;
use Slides\FrontModule\Model\SlidesGroup;
use Slides\FrontModule\Model\Dao;

class SlideGroup extends TemplateTextType implements ITemplateTextType
{
	/** @var string */
	protected $type = 'slidesByGroup';

	/** @var SlidesGroup */
	protected $slidesGroupService;

	public function __construct(SlidesGroup $slidesGroup)
	{
		$this->slidesGroupService = $slidesGroup;
	}

	/**
	 * @param BaseContainer $formContainer
	 * @param array         $params
	 */
	public function loadContainer($formContainer, $params = [])
	{
		$groups = ['' => ''];
		foreach ($this->slidesGroupService->getEr()->findBy([], ['title' => 'ASC']) as $g) {
			$groups[$g->getId()] = $g->title;
		}

		$formContainer->addSelect($this->getName(), $this->getTitle(), $groups);
	}

	/**
	 * @param $params
	 *
	 * @return Dao\Group|null
	 */
	public function render($params)
	{
		if (!isset($params['toVar']))
			throw new InvalidArgumentException('Need variable for output');

		return $this->getDefault() ? $this->slidesGroupService->get($this->getDefault()) : null;
	}
}
