<?php declare(strict_types = 1);

namespace Slides\FrontModule\Model\Dao;

use Kdyby\Doctrine\Entities\MagicAccessors;

/**
 * Class Slide
 * @package Slides\FrontModule\Model\Dao
 */
class Slide
{
	use MagicAccessors {
		__get as MA__get;
	}

	/** @var int */
	protected $id;

	/** @var string */
	protected $title;

	/** @var Group */
	protected $group;

	/** @var string */
	protected $lang;

	/** @var array */
	protected $texts;

	/** @var int */
	protected $position;

	/**
	 * @param Group $group
	 *
	 * @return $this
	 */
	public function setGroup(Group $group)
	{
		$this->group = $group;

		return $this;
	}

	public function &__get($name)
	{
		if (isset($this->texts[$name]))
			return $this->texts[$name];

		try {
			return $this->MA__get($name);
		} catch (\Exception $e) {

		}

		return null;
	}
}
