<?php declare(strict_types = 1);

namespace Slides\Model\Entities;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Criteria;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;

/**
 * @ORM\Table(name="slides__slide_group")
 * @ORM\Entity
 * @ORM\EntityListeners({"SlideGroupListener"})
 */
class SlideGroup
{
	use Identifier;
	use MagicAccessors;

	/**
	 * @var string
	 * @ORM\Column(name="title", type="string", length=255)
	 */
	public $title;

	/**
	 * @var Slide[]
	 * @ORM\OneToMany(targetEntity="Slide", mappedBy="group")
	 */
	protected $slides;

	public function __construct($title)
	{
		$this->title  = $title;
		$this->slides = new ArrayCollection();
	}

	public function getSlides()
	{
		$iterator = $this->slides->getIterator();
		$iterator->uasort(function($a, $b) {
			return ($a->getPosition() < $b->getPosition()) ? -1 : 1;
		});

		return new ArrayCollection(iterator_to_array($iterator));
	}

	public function getPublishedSlides()
	{
		$crit = (Criteria::create())->where(Criteria::expr()->eq('isPublished', 1));

		return $this->getSlides()->matching($crit);
	}
}
