<?php declare(strict_types = 1);

namespace Slides\AdminModule\Components;

use Blog\Model\UI;
use Core\Model\UI\BaseControl;
use Nette\Forms\Form;
use Nette\Http\IResponse;
use Nette\Utils\ArrayHash;
use Slides\Model\Entities\SlideGroup;

class SlideGroupForm extends BaseControl
{
	/** @var SlideGroup */
	public $slideGroup;

	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentForm()
	{
		$form = $this->createForm();

		$form->addText('title', 'default.title')->setRequired()->setMaxLength(255);
		$form->addText('speed', 'slides.slideGroupForm.speed')
			->setType('number')
			->setDefaultValue(3000)
			->setRequired();
		$form->addSubmit('submit', 'default.save');

		$form->onSuccess[] = [$this, 'formSuccess'];

		return $form;
	}

	public function formSuccess(Form $form, ArrayHash $values)
	{
		try {
			if ($this->slideGroup) {
				$group        = $this->slideGroup;
				$flashMessage = 'slides.slideGroupForm.edited';
			} else {
				$group        = new SlideGroup($values->title);
				$flashMessage = 'slides.slideGroupForm.added';
			}

			$group->title = $values->title;
			$group->speed = (int) $values->speed;

			$this->em->persist($group)->flush();
			$this->getPresenter()->flashMessageSuccess($flashMessage);
		} catch (\Exception $e) {
			$form->addError($e->getMessage());

			return false;
		}
	}

	public function setSlideGroup($id)
	{
		$this->slideGroup = $this->em->getRepository(SlideGroup::class)->find($id);

		if ($this->slideGroup) {
			$this['form']->setDefaults([
				'title' => $this->slideGroup->title,
				'speed' => $this->slideGroup->speed,
			]);
		} else
			$this->getPresenter()->error(null, IResponse::S404_NOT_FOUND);
	}
}
