<?php declare(strict_types = 1);

namespace Slides\FrontModule\Components;

use Core\Model\UI\BaseControl;
use Nette\Caching\Cache;
use Slides\Model\Entities\SlideGroup;
use Slides\Model\SlideGroups;
use Slides\Model\Slides;

class MessagesSlideshow extends BaseControl
{
	const STYLE_DEFAULT = 'Default';
	const STYLE_IMAGES  = 'Images';

	/** @var Slides[] */
	private $slides;

	/** @var SlideGroup */
	private $slideGroup;

	/** @var int */
	private $limit;

	/** @var string */
	private $style = 'default';

	/** @var string */
	private $wrapperClass;

	/** @var Slides */
	protected $slidesService;

	/** @var SlideGroups */
	protected $slideGroupsService;

	public function __construct(Slides $slides, SlideGroups $slideGroups)
	{
		$this->slidesService      = $slides;
		$this->slideGroupsService = $slideGroups;
	}

	protected function attached($presenter)
	{
		parent::attached($presenter);
	}

	public function render()
	{
		if (!$this->slides || !$this->slideGroup)
			return;

		$this->template->wrapperClass = $this->wrapperClass;
		$this->template->group        = $this->slideGroup;
		$this->template->slides       = $this->getSlides();
		$this->template->setFile(__DIR__ . '/MessagesSlideshow' . $this->style . '.latte');
		$this->template->render();
	}

	public function getSlides()
	{
		$slides = $this->slides;
		if ($this->limit)
			$slides = array_slice($slides, 0, $this->limit);

		return $slides;
	}

	public function setSlideGroup($id)
	{
		$key1             = SlideGroups::CACHE_NAMESPACE . '/' . $id . '_';
		$c1               = new Cache($this->cacheStorage, SlideGroups::CACHE_NAMESPACE);
		$this->slideGroup = $c1->load($key1, function(&$dep) use ($key1, $id) {
			$dep = [Cache::TAGS => [$key1, SlideGroups::CACHE_NAMESPACE], Cache::EXPIRE => '10 minutes'];

			$group = $this->slideGroupsService->get($id);
			$group->title;

			return $group;
		});

		$key2 = Slides::CACHE_NAMESPACE . '/published/g_' . $id;
		$c2   = new Cache($this->cacheStorage, Slides::CACHE_NAMESPACE);;
		$this->slides = $c2->load($key2, function(&$dep) use ($key2, $id) {
			$dep = [Cache::TAGS => [$key2, Slides::CACHE_NAMESPACE], Cache::EXPIRE => '10 minutes'];

			return $this->slidesService->getPublishedByGroup($id);
		});


		return $this;
	}

	public function setLimit($limit)
	{
		$this->limit = $limit;

		return $this;
	}

	public function setStyle($style)
	{
		$this->style = in_array($style, [self::STYLE_DEFAULT, self::STYLE_IMAGES]) ? $style : self::STYLE_DEFAULT;

		return $this;
	}

	public function setWrapperClass($class)
	{
		$this->wrapperClass = $class;

		return $this;
	}
}
