<?php declare(strict_types = 1);

namespace Slides\DI;

use Core\DI\CompilerExtension;
use Nette;

class SlidesExtension extends CompilerExtension
{

	public function loadConfiguration()
	{
		parent::loadConfiguration();
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		$this->compiler->loadDefinitionsFromConfig($this->loadFromFile(__DIR__ . '/services.neon'));
	}

	public function beforeCompile()
	{
		parent::beforeCompile();
		$this->setMapping(['Slides' => 'Slides\*Module\Presenters\*Presenter']);
	}
}
