<?php declare(strict_types = 1);

namespace Slides\FrontModule\Model\Dao;

/**
 * Class Group
 * @package Slides\FrontModule\Model\Dao
 */
class Group
{
	/** @var int */
	public $id;

	/** @var string */
	public $title;

	/** @var Slide */
	public $slides;

	/**
	 * @param Slide[] $slides
	 *
	 * @return $this
	 */
	public function setSlides($slides)
	{
		$this->slides = [];

		foreach ($slides as $v) {
			$this->slides[$v->id] = $v;
			$v->setGroup($this);
		}

		return $this;
	}
}
