<?php declare(strict_types = 1);

namespace Slides\FrontModule\Model;

use Core\Model\Helpers\BaseEntityService;
use Doctrine\ORM\Query;
use Nette\Caching\Cache;
use Slides\FrontModule\Model\Dao;
use Slides\Model\Entities\SlideGroup;

/**
 * Class SlidesGroup
 * @package Slides\FrontModule\Model
 *
 * @method SlideGroup|object|null getReference($id)
 */
class SlidesGroup extends BaseEntityService
{
	/** @var Slides */
	protected $slidesService;

	protected $entityClass = SlideGroup::class;

	const CACHE_NAMESPACE = 'slides';

	/** @var array */
	protected $cacheDep = [
		Cache::TAGS => ['slides'],
	];

	public function __construct(Slides $slides)
	{
		$this->slidesService = $slides;
	}

	public function getCache()
	{
		if ($this->cache === null)
			$this->cache = new Cache($this->cacheStorage, self::CACHE_NAMESPACE);

		return $this->cache;
	}

	/**
	 * @param int $id
	 *
	 * @return Dao\Group|null
	 */
	public function get($id)
	{
		$key = 'group_' . $id;

		$group = $this->getCache()->load($key, function(&$dep) use ($id) {
			$dep                = $this->cacheDep;
			$dep[Cache::TAGS][] = 'group/' . $id;

			$group = $this->getEr()->createQueryBuilder('g')
				->where('g.id = :id')->setParameter('id', $id)
				->getQuery()->getOneOrNullResult(Query::HYDRATE_ARRAY);

			return $group ? $this->fillDao($group) : null;
		});

		if ($group) {
			$group->setSlides($this->slidesService->getByGroup($id));

			return $group;
		}

		return null;
	}

	/**
	 * @param array $g
	 *
	 * @return Dao\Group
	 */
	protected function fillDao(array $g): Dao\Group
	{
		$group        = new Dao\Group();
		$group->id    = $g['id'];
		$group->title = $g['title'];

		return $group;
	}
}
