<?php declare(strict_types = 1);

namespace Slides\Model\Entities;

use Core\Model\Entities\TLang;
use Core\Model\TemplateReader\Entity\ITemplate;
use Core\Model\TemplateReader\Entity\TTemplate;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Core\Model\Entities\TId;

/**
 * @ORM\Table(name="slides__slide")
 * @ORM\Entity
 * @ORM\EntityListeners({"SlideListener"})
 */
class Slide implements ITemplate
{
	use TId;
	use TTemplate;
	use TLang;

	/**
	 * @var string
	 * @ORM\Column(name="title", type="string", length=255, nullable=false)
	 */
	public $title;

	/**
	 * @var int
	 * @ORM\Column(name="is_published", type="smallint")
	 */
	public $isPublished;

	/**
	 * @var int
	 *
	 * @Gedmo\SortablePosition
	 * @ORM\Column(name="position", type="integer")
	 */
	public $position;

	/**
	 * @var SlideGroup
	 * @Gedmo\SortableGroup
	 * @ORM\ManyToOne(targetEntity="SlideGroup", inversedBy="slides")
	 * @ORM\JoinColumn(name="group_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public $group;

	public function __construct($title, $group, $template)
	{
		$this->title       = $title;
		$this->group       = $group;
		$this->template    = $template;
		$this->isPublished = 0;
		$this->texts       = [];
		$this->setPosition(-1);
	}

	/******
	 * === Position
	 */

	public function setPosition($position)
	{
		$this->position = $position;
	}

	public function getPosition()
	{
		return $this->position;
	}
}
