<?php declare(strict_types = 1);

namespace Slides\Model\Entities;

use Doctrine;
use Doctrine\ORM\Event\LifecycleEventArgs;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Nette\Localization\ITranslator;
use Navigations\Model\Navigations;
use Nette\Caching\Cache;
use Nette\Caching\IStorage;
use Nette\SmartObject;
use Slides\FrontModule\Model\Slides;
use Slides\Model\Entities\Slide;

class SlideGroupListener implements EventSubscriberInterface
{
	use SmartObject;

	/** @var Cache */
	protected $cache;

	/** @var Cache */
	private $navigationCache;

	/** @var ITranslator */
	protected $translator;

	public function __construct(IStorage $cacheStorage, ITranslator $translator)
	{
		$this->cache           = new Cache($cacheStorage, Slides::CACHE_NAMESPACE);
		$this->navigationCache = new Cache($cacheStorage, Navigations::CACHE_NAMESPACE);
		$this->translator      = $translator;
	}

	public static function getSubscribedEvents(): array
	{
		return [];
	}

	/**
	 * @ORM\PreFlush
	 *
	 * @param SlideGroup         $slideGroup
	 * @param LifecycleEventArgs $args
	 */
	public function onPreFlush($slideGroup, $args)
	{
		$this->cache->clean([
			Cache::TAGS => [
				'slidesByGroup/' . $slideGroup->getId(),
				'group/' . $slideGroup->getId(),
			],
		]);
	}
}
