<?php

namespace Questions\AdminModule\Components\Answer;


use Core\Model\UI\BaseControl;
use Questions\Model\Answers;
use Questions\Model\Entities\Question;
use Questions\Model\Questions;

class AnswersGrid extends BaseControl
{

	/** @var Question */
	protected $question;

	/** @var Questions */
	protected $questionsService;

	/** @var Answers */
	protected $answersService;

	public function __construct(Questions $questions, Answers $answers)
	{
		$this->questionsService = $questions;
		$this->answersService = $answers;
	}

	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentGrid()
	{
		if ($this->question == null) {
			return null;
		}

		$answers = $this->question->answers;

		$grid = $this->createGrid();
		$grid->setDataSource($answers);

		/*$grid->setSortable();
		$grid->setSortableHandler('answersGrid:gridSortableRow!');
		$grid->setSortableGroup('question');*/

		$grid->addColumnLink('answer', 'questions.answerGrid.answer', 'Default:editAnswer');
		$grid->addColumnNumber('score', 'questions.answerGrid.score');
		//$grid->addColumnText('params[recommendation]', 'questions.answerGrid.recommendation');

		$grid->addAction('edit', '', 'Default:editAnswer')->setIcon('edit')->setBsType('primary');
		$grid->addAction('delete', '', 'delete!')->setConfirm('default.reallyDelete')->setIcon('times')->setBsType('danger')->addClass('ajax');

		return $grid;
	}

	public function handleGridSortableRow()
	{
		$presenter = $this->getPresenter();
		$request   = $presenter->getHttpRequest();
		$id        = $request->getPost('id', null);
		$position  = $request->getPost('position', null);
		bdump($position);

		if ($id != null && $position != null && $this->answersService->setPosition($id, $position)) {
			$presenter->flashMessageSuccess('default.positionChanged');
		} else {
			$presenter->flashMessageDanger('default.positionChangeFailed');
		}

		$presenter->redrawControl('flashes');
	}

	public function handleDelete($id)
	{
		$presenter = $this->getPresenter();
		if ($this->answersService->remove($id))
			$presenter->flashMessageSuccess('default.removed');
		else
			$presenter->flashMessageDanger('default.removeFailed');

		if ($presenter->isAjax()) {
			$this['grid']->reload();
			$presenter->redrawControl('flashes');
		} else
			$presenter->redirect('this');
	}

	public function setQuestion($id)
	{
		$this->question = $this->questionsService->get($id);
	}

}

