<?php
/**
 * Created by PhpStorm.
 * User: Adam Ouhrabka
 * Date: 16-11-2018
 * Time: 10:20
 */

namespace Questions\AdminModule\Components\Categories;

use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use Nette\Http\IResponse;
use Nette\Utils\ArrayHash;
use Questions\Model\Categories;
use Questions\Model\Entities\Category;

class CategoryForm extends BaseControl
{
	/** @var Category */
	protected $category;

	/** @var  Categories */
	protected $categoriesService;

	public function __construct(Categories $categoriesService)
	{
		$this->categoriesService = $categoriesService;
	}

	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentForm()
	{
		$form = $this->createForm();

		$categories = [null => ''];
		foreach ($this->categoriesService->getEr()->createQueryBuilder('g')->orderBy('g.title')->getQuery()->getResult() as $g) {
			/** @var Category $g */
			if ($this->category && $this->category->getId() == $g->getId())
				continue;

			$arr = [];
			$t = $g;
			$skip = false;
			while ($t->getParent()) {
				$t = $t->getParent();
				if ($this->category && $this->category->getId() == $t->getId()) {
					$skip = true;
				}

				$arr[] = $t->title;
			}

			if ($skip)
				continue;

			$categories[$g->getId()] = ($arr ? implode(' -> ', $arr) . ' -> ' : '') . $g->title;
		}

		$form->addText('title', 'default.title')->setRequired()->setMaxLength(255);
		$form->addBool('isPublished', 'default.isPublished')->setDefaultValue(1);
		$form->addSelect('parent', 'default.parent', $categories);
		$form->addSubmit('submit', 'default.save');

		$form->onSuccess[] = [$this, 'formSuccess'];

		return $form;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values)
	{
		try {
			if ($this->category) {
				$group = $this->category;
				$flashMessage = 'questions.categoriesForm.edited';
			} else {
				$group = new Category($values->title);
				$flashMessage = 'questions.categoriesForm.added';
			}

			$group->title = $values->title;
			$group->isPublished = $values->isPublished;

			if ($values->parent == '') {
				$group->setParent(null);
			} else {
				$group->setParent($this->categoriesService->get($values->parent));
			}

			$this->em->persist($group)->flush();
			$this->getPresenter()->flashMessageSuccess($flashMessage);
		} catch (\Exception $e) {
			$form->addError($e->getMessage());

			return false;
		}
	}

	public function setCategory($id)
	{
		$this->category = $this->categoriesService->get($id);

		if ($this->category) {
			$this['form']->setDefaults([
				'title' => $this->category->title,
				'isPublished' => $this->category->isPublished,
			]);

			if ($this->category->parent && array_key_exists($this->category->parent->getId(), $this['form']['parent']->getItems())) {
				$this['form']['parent']->setDefaultValue($this->category->parent->getId());
			}
		} else
			$this->getPresenter()->error(null, IResponse::S404_NOT_FOUND);
	}


}