<?php
/**
 * Created by PhpStorm.
 * User: Adam Ouhrabka
 * Date: 11.10.2018
 * Time: 11:33
 */

namespace Questions\AdminModule\Components\Products;


use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use Nette\Utils\ArrayHash;
use Questions\Model\Answers;
use Questions\Model\Entities\Answer;
use SimpleProducts\Model\Entities\Product;
use SimpleProducts\Model\SimpleProducts;

class ProductsGrid extends BaseControl
{
	/**
	 * @var SimpleProducts
	 */
	protected $productsServices;

	/** @var Answers */
	protected $answersServices;

	protected $answer;

	/** @var Product[] */
	protected $assignedProducts = [];

	public $onAdd = [];


	public function __construct(SimpleProducts $products, Answers $answers)
	{
		$this->productsServices = $products;
		$this->answersServices = $answers;
	}

	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}

	public function createComponentForm()
	{
		$form = $this->createForm();
		$form->setAjax();

		$products = [];
		foreach ($this->productsServices->getAll() as $p) {
			$products[$p->id] = $p->title;
		}

		$form->addSelect('assignedProducts', 'questions.answerForm.assignedProducts', $products);
		$form->addText('productScore', 'questions.answerForm.assignedProductsScore')->setDefaultValue(1);
		$form->addHidden('productsField', 'questions.answerForm.products')->setHtmlId("productsField");
		$form->addSubmit('submit','questions.answerForm.addProduct');
		$form->onSuccess[] = [$this,'formSuccess'];
		return $form;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values) {

		$product = ['id' => $values->assignedProducts, 'score' => $values->productScore];
		$products = $this->answer->getParam('products');
		$products[$product['id']] = $product;

		$this->answer->setParam('products', $products);
		$this->em->persist($this->answer)->flush();

		$this['grid']->reload();
	}

	public function createComponentGrid()
	{
		$grid = $this->createGrid();

		$products = [];

		if (!empty($this->answer->getParam('products')))
			$this->assignedProducts = $this->answer->getParam('products');

		foreach ($this->assignedProducts as $key => $product) {
			$products[$key]['title'] = $this->productsServices->get($key)->title;
			$products[$key]['score'] = $product['score'] . "x";
			$products[$key]['id'] = $key;
		}

		$grid->setDataSource($products);
		$grid->addColumnLink('title', 'questions.productGrid.product');
		$grid->addColumnText('score', 'questions.productGrid.score');
		$grid->addAction('delete', '', 'delete!')->setConfirm('default.reallyDelete')->setIcon('times')->setBsType('danger')->addClass('ajax');

		$this->onAdd[] = function () {
			$this['grid']->reload();
		};

		return $grid;
	}

	public function handleDelete($id)
	{
		/** @var Answer */
		$presenter = $this->getPresenter();
		$products = $this->answer->getParam('products');
		unset($products[$id]);

		$this->answer->setParam('products', $products);
		$this->em->persist($this->answer)->flush();

		if ($presenter->isAjax()) {
			$this->redrawControl("component");
			$presenter->redrawControl('flashes');
		}

		$this['grid']->reload();

	}


	public function setAnswer($id)
	{
		/** @var Answer */
		$this->answer = $this->answersServices->get($id);
	}

}

