<?php declare(strict_types=1);

namespace Surveys\AdminModule\Components\Question;


use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use Nette\Http\IResponse;
use Nette\Utils\ArrayHash;
use Surveys\Model\Entities\Question;
use Surveys\Model\Questions;


class QuestionForm extends BaseControl
{
	/** @var Question */
	protected $question;

	/** @var Questions */
	protected $questionsService;

	public function __construct()
	{

	}

	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentForm()
	{
		$form = $this->createForm();

		$form->addTextArea('question', 'surveys.default.question')->setRequired();
		$form->addFilesManager('image', 'surveys.default.question')->setRequired();
		$form->addBool('isPublished', 'default.isPublished')->setDefaultValue(1);
		$form->addTextArea('hint', 'surveys.questionForm.hint');
		$form->addText('class', 'surveys.questionForm.class');
		$form->addCheckbox('multipleAnswers', 'surveys.questionForm.multipleAnswers')->setDefaultValue(0);

		$form->addSaveCancelControl('saveControl');

		$form->onSuccess[] = [$this, 'formSuccess'];

		return $form;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values)
	{
		try {
			if ($this->question) {
				$question = $this->question;
				$flashMessage = 'questions.categoriesForm.edited';
			} else {
				$question = new Question($values->question);
				$flashMessage = 'questions.categoriesForm.added';
			}

			$question->question = $values->question;
			$question->score = $values->score;
			$question->questionClass = $values->questionClass;
			$question->isPublished = $values->isPublished;
			$question->hint = $values->hint;
			$question->multipleAnswers = $values->multipleAnswers;

			$question->groups = [$this->categoriesService->get($values->category)];

			$this->em->persist($question)->flush();
			$this->getPresenter()->flashMessageSuccess($flashMessage);
		} catch (\Exception $e) {
			$form->addError($e->getMessage());

			return false;
		}

		return true;

	}

	public function setQuestion($id)
	{
		$this->question = $this->questionsService->get($id);

		if ($this->question) {
			$this['form']->setDefaults([
				'question' => $this->question->question,
				'isPublished' => $this->question->isPublished,
				'score' => $this->question->score,
				'questionClass' => $this->question->questionClass,
				'hint' => $this->question->hint,
				'multipleAnswers' => $this->question->multipleAnswers,
				'category' => $this->question->groups[0]->getId()
			]);

		} else
			$this->getPresenter()->error(null, IResponse::S404_NOT_FOUND);
	}


}
