<?php declare(strict_types=1);

namespace Surveys\AdminModule\Components\Question;

use Core\Model\UI\BaseControl;
use Surveys\Model\Entities\Survey;
use Surveys\Model\Questions;
use Surveys\Model\Surveys;

class QuestionsGrid extends BaseControl
{

	/** @var Survey */
	protected $survey;

	/** @var Questions */
	protected $questionsService;

	/** @var Surveys */
	protected $surveysService;

	public function __construct(Questions $questionsService, Surveys $surveysService)
	{
		$this->questionsService = $questionsService;
		$this->surveysService = $surveysService;
	}

	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentGrid()
	{
		$grid = $this->createGrid();

		$qb = $this->questionsService->getAll();
		$grid->setDataSource($qb);

		$grid->setDefaultPerPage(20);

		$grid->addColumnLink('question', 'surveys.questionsGrid.question', 'Default:editQuestion');

		$grid->addColumnStatus('isPublished', 'default.isPublished')->setAlign('center')
			->addOption(1, 'default.publish')->setIcon('check')->setClass('btn-success')->setShowTitle(false)->endOption()
			->addOption(0, 'default.unPublish')->setIcon('times')->setClass('btn-danger')->setShowTitle(false)->endOption()
			->onChange[] = [$this, 'gridPublishChange'];

		// Actions
		$grid->addAction('edit', '', 'Default:editQuestion')->setIcon('edit')->setBsType('primary');
		$grid->addAction('delete', '', 'delete!')->setConfirm('default.reallyDelete')->setIcon('times')->setBsType('danger')->addClass('ajax');

		// Columns prototype
		$grid->getColumn('isPublished')->getElementPrototype('th')->class[] = 'w1';

		return $grid;
	}

	public function handleDelete($id)
	{
		$presenter = $this->getPresenter();
		if ($this->questionsService->remove($id))
			$presenter->flashMessageSuccess('default.removed');
		else
			$presenter->flashMessageDanger('default.removeFailed');

		if ($presenter->isAjax()) {
			$this['grid']->reload();
			$presenter->redrawControl('flashes');
		} else
			$presenter->redirect('this');
	}

	public function setSurvey($id)
	{
		$this->survey = $this->surveysService->get($id);
	}

	/*******************************************************************************************************************
	 * =================  Grid function
	 */

	public function gridPublishChange($id, $newStatus)
	{
		$presenter = $this->getPresenter();

		if ($this->questionsService->setPublish($id, $newStatus))
			$presenter->flashMessageSuccess('default.publishChanged');
		else
			$presenter->flashMessageDanger('default.publishChangeFailed');

		if ($presenter->isAjax()) {
			$this['grid']->redrawItem($id);
			$presenter->redrawControl('flashes');
		} else
			$presenter->redirect('this');
	}
}

