<?php

namespace Surveys\AdminModule\Components\Survey;


use Core\Model\UI\BaseControl;
use Questions\Model\Answers;
use Questions\Model\Entities\Question;
use Questions\Model\Questions;
use Surveys\Model\Surveys;

class SurveysGrid extends BaseControl
{

	/** @var Surveys */
	protected $surveysService;

	public function __construct(Surveys $surveys)
	{
		$this->surveysService = $surveys;
	}


	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentGrid()
	{

		$surveys = $this->surveysService->getAll();

		$grid = $this->createGrid();
		$grid->setDataSource($surveys);

		$grid->addColumnLink('title', 'surveys.surveysGrid.title', 'Default:editSurvey');

		$grid->addColumnStatus('isPublished', 'default.isPublished')->setAlign('center')
			->addOption(1, 'default.publish')->setIcon('check')->setClass('btn-success')->setShowTitle(false)->endOption()
			->addOption(0, 'default.unPublish')->setIcon('times')->setClass('btn-danger')->setShowTitle(false)->endOption()
			->onChange[] = [$this, 'gridPublishChange'];

		$grid->addAction('edit', '', 'Default:editAnswer')->setIcon('edit')->setBsType('primary');
		$grid->addAction('delete', '', 'delete!')->setConfirm('default.reallyDelete')->setIcon('times')->setBsType('danger')->addClass('ajax');

		return $grid;
	}

	public function handleGridSortableRow()
	{
		$presenter = $this->getPresenter();
		$request   = $presenter->getHttpRequest();
		$id        = $request->getPost('id', null);
		$position  = $request->getPost('position', null);

		if ($id != null && $position != null && $this->answersService->setPosition($id, $position)) {
			$presenter->flashMessageSuccess('default.positionChanged');
		} else {
			$presenter->flashMessageDanger('default.positionChangeFailed');
		}

		$presenter->redrawControl('flashes');
	}

	public function handleDelete($id)
	{
		$presenter = $this->getPresenter();
		if ($this->surveysService->remove($id))
			$presenter->flashMessageSuccess('default.removed');
		else
			$presenter->flashMessageDanger('default.removeFailed');

		if ($presenter->isAjax()) {
			$this['grid']->reload();
			$presenter->redrawControl('flashes');
		} else
			$presenter->redirect('this');
	}

	public function gridPublishChange($id, $newStatus)
	{
		$presenter = $this->getPresenter();

		if ($this->surveysService->setPublish($id, $newStatus))
			$presenter->flashMessageSuccess('default.publishChanged');
		else
			$presenter->flashMessageDanger('default.publishChangeFailed');

		if ($presenter->isAjax()) {
			$this['grid']->redrawItem($id);
			$presenter->redrawControl('flashes');
		} else
			$presenter->redirect('this');
	}

	public function setQuestion($id)
	{
		$this->question = $this->questionsService->get($id);
	}

}

