<?php declare(strict_types=1);

namespace Surveys\AdminModule\Presenters;

use Core\Model\UI\Form\BaseForm;
use Nette\Http\IResponse;
use Questions\Model\Entities\Answer;
use Questions\Model\Entities\Category;
use Questions\Model\Entities\Question;
use Surveys\AdminModule\Components\Question\IQuestionFormFactory;
use Surveys\AdminModule\Components\Question\IQuestionsGridFactory;
use Surveys\AdminModule\Components\Survey\ISurveyFormFactory;
use Surveys\AdminModule\Components\Survey\ISurveysGridFactory;
use Surveys\Model\Entities\Survey;

final class DefaultPresenter extends BasePresenter
{
	protected function startup()
	{
		parent::startup();
		$this['title']->setTitle($this->translator->translate('surveys.title.surveys'));
		$this->setHeader('surveys.title.surveys', 'fas fa-chart-pie');
	}

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionDefault()
	{
		$this['navigation']->setData(['header' => [
			[
				'title' => 'surveys.menu.addSurvey',
				'link' => 'Default:addSurvey',
				'ico' => 'plus',
			]
		]]);
	}

	public function actionAddSurvey()
	{
		$this->setTitle($this->translator->translate('surveys.title.addSurvey'));
		$this->setHeader('surveys.title.addSurvey', 'fas fa-chart-pie');
	}

	public function actionAddQuestion()
	{
		$this->setTitle($this->translator->translate('surveys.title.addQuestion'));
		$this->setHeader('surveys.title.addQuestion', 'fas fa-chart-pie');
	}

	public function actionEditSurvey($id)
	{
		$this['navigation']->setData(['header' => [
			[
				'title' => 'surveys.menu.addQuestion',
				'link' => 'Default:addQuestion',
				'ico' => 'plus',
			]
		]]);

		$survey = $this->em->getRepository(Survey::class)->find($id);

		if (!$survey)
			$this->error(null, IResponse::S404_NOT_FOUND);

		$this->setTitle($this->translator->translate('surveys.title.editSurvey'));
		$this->setHeader('surveys.title.editSurvey', 'fas fa-chart-pie');
	}

	public function actionEditCategory($id)
	{
		$category = $this->em->getRepository(Category::class)->find($id);

		if (!$category)
			$this->error(null, IResponse::S404_NOT_FOUND);

		$this->setTitle($this->translator->translate('surveys.title.editCategory'));
		$this->setHeader('surveys.title.editCategory', 'fas fa-question');
	}

	public function actionEditQuestion($id)
	{
		$question = $this->em->getRepository(Question::class)->find($id);

		if (!$question)
			$this->error(null, IResponse::S404_NOT_FOUND);

		$this->setTitle($this->translator->translate('surveys.title.editQuestion'));
		$this->setHeader('surveys.title.editQuestion', 'fas fa-question');
	}

	public function actionEditAnswer($id)
	{
		$answer = $this->em->getRepository(Answer::class)->find($id);
		if (!$answer)
			$this->error(null, IResponse::S404_NOT_FOUND);

		$this->setTitle($this->translator->translate('surveys.title.editAnswer'));
		$this->setHeader('surveys.title.editAnswer', 'fas fa-question');
	}

	/**
	 * Components
	 */

	protected function createComponentSurveysGrid(ISurveysGridFactory $factory)
	{
		$control = $factory->create();


		return $control;
	}

	protected function createComponentSurveyForm(ISurveyFormFactory $factory)
	{
		$control = $factory->create();


		if ($this->getParameter('id'))
			$control->setSurvey($this->getParameter('id'));

		$control['form']->onSuccessSave[] = function (BaseForm $form) {
			$this->redirect('edit', $form->getCustomData('navigationId'));
		};

		$control['form']->onSuccessSaveAndClose[] = function (BaseForm $form) {
			$this->redirect('default');
		};

		$control['form']->onCancel[] = function (BaseForm $form) {
			$this->redirect('default');
		};

		return $control;
	}

	protected function createComponentQuestionsGrid(IQuestionsGridFactory $factory)
	{
		$control = $factory->create();

		if ($this->getParameter('id')) {
			$control->setSurvey($this->getParameter('id'));
		}

		return $control;
	}

	protected function createComponentQuestionForm(IQuestionFormFactory $factory)
	{
		$control = $factory->create();

		if ($this->getParameter('id')) {
			$control->setQuestion($this->getParameter('id'));
		}

		return $control;
	}


}