<?php
/**
 * Created by PhpStorm.
 * User: Adam Ouhrabka
 * Date: 11.10.2018
 * Time: 14:15
 */

namespace Questions\FrontModule\Model;


use Core\Model\Helpers\BaseEntityService;
use Questions\Model\Entities\Category;
use Questions\FrontModule\Model\Dao as QuestionsDao;

class Categories extends BaseEntityService
{
	protected $entityClass = Category::class;

	public function getAllByRootGroups($publishedOnly = false)
	{
		$categoriesRaw = $this->getEr()->createQueryBuilder('c')
			->where('c.parent IS NULL')
			->orderBy('c.position', 'ASC')
			->getQuery()
			->getResult();

		$categories = [];
		foreach ($categoriesRaw as $c) {
			$category = (new QuestionsDao\Category())
				->setId($c->getId())
				->setTitle($c->title)
				->setClass($c->class);

			$questions = [];

			foreach ($c->children as $child) {
				$questions += $this->getQuestions($child, $publishedOnly);
			}

			$questions += $this->getQuestions($c, $publishedOnly);

			$category->setQuestions($questions);
			$categories[$category->id] = $category;

		}

		return $categories;

	}

	private function getQuestions($c, $publishedOnly = false)
	{
		$questions = [];
		foreach ($c->questions as $q) {

			if($publishedOnly && $q->isPublished == 0) continue;

			$question = (new QuestionsDao\Question())
				->setId($q->id)
				->setQuestion($q->question)
				->setIsPublished($q->isPublished)
				->setClass($q->questionClass)
				->setMultipleAnswers($q->multipleAnswers)
				->setGroups($q->groups)
				->setFirstParent($c)
				->setFirstParentId($c->getId());

			$answers = [];
			foreach ($q->answers as $a) {
				$answer = (new QuestionsDao\Answer())
					->setIsPublished($a->isPublished)
					->setId($a->id)
					->setAnswer($a->answer)
					->setScore($a->score)
					->setQuestion($a->question)
					->setParams($a->params)
					->setClass($a->answerClass);
				$answers[$answer->id] = $answer;
			}

			$question->setAnswers($answers);
			$questions[$question->id] = $question;
		}

		return $questions;

	}

}