<?php declare(strict_types = 1);

namespace Questions\FrontModule\Model;


use Core\Model\Helpers\BaseEntityService;
use Questions\Model\Entities\Question;
use Questions\FrontModule\Model\Dao as DaoQuestions;


class Questions extends BaseEntityService
{
	protected $entityClass = Question::class;

	public function getAllByGroups()
	{

		$questionsRaw = $this->getAll();

		$questions = [];
		foreach ($questionsRaw as $q) {

			$question = (new DaoQuestions\Question())
				->setId($q->getId())
				->setQuestion($q->question)
				->setIsPublished($q->isPublished)
				->setMultipleAnswers($q->multipleAnswers);

			$answers = [];
			foreach ($q->answers as $a) {
				$answers[] = (new DaoQuestions\Answer())
					->setIsPublished($a->isPublished)
					->setId($a->getId())
					->setAnswer($a->answer)
					->setScore($a->score)
					->setQuestion($q)
					->setParams($a->params);
			}

			$question->setAnswers($answers);
			$questions[$question->id] = $question;
		}

		return $questions;
	}
}