<?php declare(strict_types = 1);

namespace Surveys\Model\Entities;

use Doctrine\Common\Collections\ArrayCollection;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;
use Gedmo\Mapping\Annotation as Gedmo;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="surveys__answer")
 * @ORM\Entity(repositoryClass="Core\Model\Entities\Repository\SortableRepository")
 */
class Answer
{
	use Identifier;
	use MagicAccessors;

	/**
	 * @var string
	 * @ORM\Column(name="answer", type="string", length=1000)
	 */
	public $answer;

	/**
	 * @var string
	 * @ORM\Column(name="image", type="string", length=255, nullable=true)
	 */
	public $image;

	/**
	 * @var int
	 * @ORM\Column(name="votes", type="integer", length=1000 , options={"default":0})
	 */
	public $votes;

	/**
	 * @var int
	 * @Gedmo\SortablePosition
	 * @ORM\Column(name="position", type="integer")
	 */
	public $position;

	/**
	 * @var boolean
	 * @ORM\Column(name="is_published", type="smallint", options={"default":1})
	 */
	public $isPublished;

	/**
	 * @var string
	 * @ORM\Column(name="class", type="string", nullable=true)
	 */
	public $class;

	/**
	 * @var Question
	 * @ORM\ManyToOne(targetEntity="Question", inversedBy="answers")
	 * @ORM\JoinColumn(name="question_id", referencedColumnName="id")
	 */
	public $question;

	/**
	 * @var array
	 * @ORM\Column(name="params", type="array", nullable=true)
	 */
	public $params;

	public function __construct($title)
	{
		$this->title = $title;
		$this->params = [];
	}

	public function setPosition($position)
	{
		$this->position = $position;
	}

	public function getPosition()
	{
		return $this->position;
	}

	public function setParam($key, $value)
	{
		if ($value === null) {
			unset($this->params[$key]);
		} else {
			$this->params[$key] = $value;
		}
	}

	public function getParam($key)
	{
		return $this->params[$key] ?? null;
	}

}
