<?php declare(strict_types = 1);

namespace Surveys\Model\Navigation;


use Core\Model\UI\Form\BaseContainer;
use Core\Model\UI\Form\BaseForm;
use Navigations\Model\Entities\Navigation;
use Navigations\Model\Providers\INavigationItem;
use Nette\Utils\ArrayHash;

class Surveys extends BaseNavigation implements INavigationItem
{

	protected $title = 'surveys';
	protected $presenter = 'Surveys:Front:Default';
	protected $action = 'default';

	public function __construct()
	{

	}

	/**
	 * @return BaseContainer
	 */
	public function getFormContainer()
	{
		$container = new BaseContainer();

		return $container;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values)
	{

	}


	public function presenterActionCheck($presenter, $action)
	{
		if ($this->presenter == $presenter && $this->action == $action)
			return 1;

		return false;
	}


	public function routerIn($componentParams, $urlParams = [])
	{
		return [
			'presenter' => $this->presenter,
			'action' => $this->action,
			'id' => null
		];
	}

	/**
	 * @param Navigation $navigation
	 * @param array $id
	 *
	 * @return bool
	 */
	public function routerOut($navigation, &$id)
	{
		return $navigation->isHomepage ? '' : '/' . $navigation->alias;
	}
}