<?php declare(strict_types = 1);

namespace Surveys\AdminModule\Components\Answer;

use Core\Model\UI\Form\BaseForm;
use Core\Model\UI\BaseControl;
use SimpleProducts\Model\SimpleProducts;
use Surveys\Model\Answers;
use Nette\Utils\ArrayHash;
use Surveys\Model\Entities\Answer;
use Surveys\Model\Entities\Question;
use Surveys\Model\Questions;

class AnswerForm extends BaseControl
{

	/** @var Answer */
	protected $answer;

	/** @var Question */
	protected $question;

	/** @var Questions */
	protected $questionsService;

	/** @var  Answers */
	protected $answersService;

	public function __construct(Questions $questionsService, Answers $answersService)
	{
		$this->questionsService = $questionsService;
		$this->answersService = $answersService;
	}

	public function render(): void
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentForm(): BaseForm
	{
		$form = $this->createForm();

		$form->addTextArea('answer', 'surveys.answerForm.answer')->setRequired();
		$form->addFilesManager('image','surveys.answerForm.image');
		$form->addBool('isPublished', 'default.isPublished')->setDefaultValue(1);
		$form->addText('class', 'surveys.answerForm.class');
		$form->addInteger('votes', 'surveys.answerForm.votes')->setDefaultValue(0);

		$form->addSaveCancelControl();
		$form->onSuccess[] = [$this, 'formSuccess'];

		return $form;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values): bool
	{
		try {
			if ($this->answer) {
				$answer = $this->answer;
				$flashMessage = 'questions.categoriesForm.edited';
			} else {
				$answer = new Answer($values->answer);
				$answer->question = $this->question;
				$flashMessage = 'questions.categoriesForm.added';
			}

			$answer->answer = $values->answer;
			$answer->isPublished = $values->isPublished;
			$answer->image = $values->image;
			$answer->class = $values->class;
			$answer->votes = $values->votes;

			$this->em->persist($answer)->flush();
			$this->getPresenter()->flashMessageSuccess($flashMessage);
		} catch (\Exception $e) {
			$form->addError($e->getMessage());
			return false;
		}

		return true;
	}

	public function setQuestion($id): void
	{
		$this->question = $this->questionsService->get($id);
	}

	public function setAnswer($id)
	{
		$a = $this->answer = $this->answersService->get($id);

		if ($this->answer) {
			$this['form']->setDefaults([
				'answer'      => $a->answer,
				'votes'       => $a->votes,
				'isPublished' => $a->isPublished,
				'class'       => $a->class,
			]);
		} else {
			$this->getPresenter()->error(null, IResponse::S404_NOT_FOUND);
		}
	}

}
